IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_REQ_TRANSF_LIB_EST_WMS_ENT_INSERIR]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_REQ_TRANSF_LIB_EST_WMS_ENT_INSERIR]
GO
GO
GO
GO
CREATE PROCEDURE P_EST_PROD_REQ_TRANSF_LIB_EST_WMS_ENT_INSERIR @CD_EMP			INT, 
												  @CD_FILIAL	INT,  
												  @CD_REQ		INT,
												  @DT_CAD			DATETIME,
												  @CD_ORIG			INT,
												  @CD_USU			INT,
												  @NM_ORIG			VARCHAR(150),
												  @CD_DEPO_DEST		INT
												  AS

	BEGIN
		-------------------------------------------------------------------------------
		--Gravando o cabealho da integrao
		-------------------------------------------------------------------------------
		INSERT INTO EST_WMS_ENT (DT_PED, CD_USU, DT_CAD, DT_ULT_ALT, STS_PED, CD_DEST_ORIG, NM_DEST_ORIG, TIPO_DOCUMENTO, DT_EMI_DOC,CD_DEPO_DEST)
		SELECT	
				@DT_CAD, 
				@CD_USU,
				GETDATE(),
				NULL,
				0,
				CAST ('2' + RIGHT('00000000' + CAST(@CD_ORIG AS VARCHAR), 8) AS NUMERIC) AS CD_FORN,
				@NM_ORIG,
				2,
				@DT_CAD,
				@CD_DEPO_DEST
		-------------------------------------------------------------------------------
		--Gravando os itens da integrao
		-------------------------------------------------------------------------------
		INSERT INTO EST_WMS_ENT_IT (CD_PED_WMS, CD_PROD, LOTE, QT_PROD, CD_EMP)	
		SELECT     
			IDENT_CURRENT('EST_WMS_ENT'),
			EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD,
			'ND',
			EST_PROD_REQ_TRANSF_LIB_ITENS.QT_PROD AS QT_IT,
			EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP
		FROM
			EST_PROD_REQ_TRANSF_LIB INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON 
			EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP AND 
			EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL AND 
			EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ
		WHERE        
			EST_PROD_REQ_TRANSF_LIB.CD_EMP = @CD_EMP 
			AND EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = @CD_ORIG 
			AND EST_PROD_REQ_TRANSF_LIB.CD_REQ = @CD_REQ

		-------------------------------------------------------------------------------
		--Gravando relacionamento da integracao
		-------------------------------------------------------------------------------
		INSERT INTO EST_PROD_REQ_TRANSF_LIB_EST_WMS_ENT(CD_EMP, 
														CD_FILIAL,
														CD_REQ,
														CD_PED_WMS,
														DT_CAD)
		SELECT 
			@CD_EMP, 
			@CD_ORIG,  
			@CD_REQ,
			IDENT_CURRENT('EST_WMS_ENT'),
			GETDATE()
END	
